implementation module windowdefaccess


import	StdTuple, StdList
import	commondef, StdWindowDef


//	Get & Set the WindowAttributes:

getWindowAttributes :: !(Window c .ls .ps) -> (![WindowAttribute *(.ls,.ps)],!Window c .ls .ps)
getWindowAttributes wdef=:(Window _ _ atts) = (atts,wdef)

setWindowAttributes :: ![WindowAttribute *(.ls,.ps)] !(Window c .ls .ps) -> Window c .ls .ps
setWindowAttributes atts (Window title controls _) = Window title controls atts


//	Get & Set the DialogAttributes:

getDialogAttributes :: !(Dialog c .ls .ps) -> (![WindowAttribute *(.ls,.ps)],!Dialog c .ls .ps)
getDialogAttributes ddef=:(Dialog _ _ atts) = (atts,ddef)

setDialogAttributes :: ![WindowAttribute *(.ls,.ps)] !(Dialog c .ls .ps) -> Dialog c .ls .ps
setDialogAttributes atts (Dialog title controls _) = Dialog title controls atts


//	Frequently used predicates on the WindowAttributes:

isAllWindowsAttribute :: !(WindowAttribute .ps) -> Bool
isAllWindowsAttribute (WindowId			_)		= True
isAllWindowsAttribute (WindowPos		_)		= True
isAllWindowsAttribute (WindowIndex		_)		= True
isAllWindowsAttribute (WindowSize		_)		= True
isAllWindowsAttribute (WindowHMargin   _ _)		= True
isAllWindowsAttribute (WindowVMargin   _ _)		= True
isAllWindowsAttribute (WindowItemSpace _ _)		= True
isAllWindowsAttribute (WindowOk			_)		= True
isAllWindowsAttribute (WindowCancel		_)		= True
isAllWindowsAttribute WindowHide				= True
isAllWindowsAttribute (WindowClose		_)		= True
isAllWindowsAttribute (WindowInit		_)		= True
isAllWindowsAttribute _							= False

isWindowOnlyAttribute :: !(WindowAttribute .ps) -> Bool
isWindowOnlyAttribute (WindowLook		_)		= True
isWindowOnlyAttribute (WindowSelectState _)		= True
isWindowOnlyAttribute (WindowViewDomain	_)		= True
isWindowOnlyAttribute (WindowOrigin		_)		= True
isWindowOnlyAttribute (WindowHScroll	_)		= True
isWindowOnlyAttribute (WindowVScroll	_)		= True
isWindowOnlyAttribute (WindowMinimumSize _)		= True
isWindowOnlyAttribute  WindowResize				= True
isWindowOnlyAttribute (WindowActivate	_)		= True
isWindowOnlyAttribute (WindowDeactivate	_)		= True
isWindowOnlyAttribute (WindowMouse		_ _ _)	= True
isWindowOnlyAttribute (WindowKeyboard	_ _ _)	= True
isWindowOnlyAttribute (WindowCursor		_)		= True
isWindowOnlyAttribute _							= False

isDialogOnlyAttribute :: !(WindowAttribute .ps) -> Bool
isDialogOnlyAttribute _							= False

iswindowid			:: !(WindowAttribute .ps) -> Bool
iswindowid			(WindowId _)			= True
iswindowid			_						= False

iswindowpos			:: !(WindowAttribute .ps) -> Bool
iswindowpos			(WindowPos _)			= True
iswindowpos			_						= False

iswindowindex		:: !(WindowAttribute .ps) -> Bool
iswindowindex		(WindowIndex _)			= True
iswindowindex		_						= False

iswindowsize		:: !(WindowAttribute .ps) -> Bool
iswindowsize		(WindowSize _)			= True
iswindowsize		_						= False

iswindowok			:: !(WindowAttribute .ps) -> Bool
iswindowok			(WindowOk _)			= True
iswindowok			_						= False

iswindowcancel		:: !(WindowAttribute .ps) -> Bool
iswindowcancel		(WindowCancel _)		= True
iswindowcancel		_						= False

iswindowhmargin		:: !(WindowAttribute .ps) -> Bool
iswindowhmargin		(WindowHMargin _ _)		= True
iswindowhmargin		_						= False

iswindowvmargin		:: !(WindowAttribute .ps) -> Bool
iswindowvmargin		(WindowVMargin _ _)		= True
iswindowvmargin		_						= False

iswindowitemspace	:: !(WindowAttribute .ps) -> Bool
iswindowitemspace	(WindowItemSpace _ _)	= True
iswindowitemspace	_						= False

iswindowclose		:: !(WindowAttribute .ps) -> Bool
iswindowclose		(WindowClose _)			= True
iswindowclose		_						= False

iswindowinit		:: !(WindowAttribute .ps) -> Bool
iswindowinit		(WindowInit _)			= True
iswindowinit		_						= False

iswindowhide		:: !(WindowAttribute .ps) -> Bool
iswindowhide		WindowHide				= True
iswindowhide		_						= False

iswindowlook		:: !(WindowAttribute .ps) -> Bool
iswindowlook		(WindowLook _)			= True
iswindowlook		_						= False

iswindowselectstate	:: !(WindowAttribute .ps) -> Bool
iswindowselectstate	(WindowSelectState _)	= True
iswindowselectstate	_						= False

iswindowviewdomain	:: !(WindowAttribute .ps) -> Bool
iswindowviewdomain	(WindowViewDomain _)	= True
iswindowviewdomain	_						= False

iswindowhscroll		:: !(WindowAttribute .ps) -> Bool
iswindowhscroll		(WindowHScroll _)		= True
iswindowhscroll		_						= False

iswindowvscroll		:: !(WindowAttribute .ps) -> Bool
iswindowvscroll		(WindowVScroll _)		= True
iswindowvscroll		_						= False

iswindoworigin		:: !(WindowAttribute .ps) -> Bool
iswindoworigin		(WindowOrigin _)		= True
iswindoworigin		_						= False

iswindowminimumsize	:: !(WindowAttribute .ps) -> Bool
iswindowminimumsize	(WindowMinimumSize _)	= True
iswindowminimumsize	_						= False

iswindowresize		:: !(WindowAttribute .ps) -> Bool
iswindowresize		WindowResize			= True
iswindowresize		_						= False

iswindowactivate	:: !(WindowAttribute .ps) -> Bool
iswindowactivate	(WindowActivate _)		= True
iswindowactivate	_						= False

iswindowdeactivate	:: !(WindowAttribute .ps) -> Bool
iswindowdeactivate	(WindowDeactivate _)	= True
iswindowdeactivate	_						= False

iswindowmouse		:: !(WindowAttribute .ps) -> Bool
iswindowmouse		(WindowMouse _ _ _)		= True
iswindowmouse		_						= False

iswindowkeyboard	:: !(WindowAttribute .ps) -> Bool
iswindowkeyboard	(WindowKeyboard _ _ _)	= True
iswindowkeyboard	_						= False

iswindowcursor		:: !(WindowAttribute .ps) -> Bool
iswindowcursor		(WindowCursor _)		= True
iswindowcursor		_						= False


getwindowid :: !(WindowAttribute .ps) -> Id
getwindowid (WindowId id) = id

getwindowpos :: !(WindowAttribute .ps) -> ItemPos
getwindowpos (WindowPos pos) = pos

getwindowindex :: !(WindowAttribute .ps) -> Int
getwindowindex (WindowIndex index) = index

getwindowsize :: !(WindowAttribute .ps) -> Size
getwindowsize (WindowSize size) = size

getwindowitemspace :: !(WindowAttribute .ps) -> (Int,Int)
getwindowitemspace (WindowItemSpace hspace vspace) = (hspace,vspace)

getwindowok :: !(WindowAttribute .ps) -> Id
getwindowok (WindowOk id) = id

getwindowcancel :: !(WindowAttribute .ps) -> Id
getwindowcancel (WindowCancel id) = id

getwindowhmargin :: !(WindowAttribute .ps) -> (Int,Int)
getwindowhmargin (WindowHMargin left right) = (left,right)

getwindowvmargin :: !(WindowAttribute .ps) -> (Int,Int)
getwindowvmargin (WindowVMargin top bottom) = (top,bottom)

getwindowclosefunction :: !(WindowAttribute .ps) -> IOFunction .ps
getwindowclosefunction (WindowClose f) = f

getwindowinit :: !(WindowAttribute .ps) -> [IdFun .ps]
getwindowinit (WindowInit init) = init

getwindowlook :: !(WindowAttribute .ps) -> Look
getwindowlook (WindowLook f) = f

getwindowselectstate :: !(WindowAttribute .ps) -> SelectState
getwindowselectstate (WindowSelectState select) = select

getwindowviewdomain :: !(WindowAttribute .ps) -> ViewDomain
getwindowviewdomain (WindowViewDomain pd) = pd

getwindowhscrollfunction :: !(WindowAttribute .ps) -> ScrollFunction
getwindowhscrollfunction (WindowHScroll f) = f

getwindowvscrollfunction :: !(WindowAttribute .ps) -> ScrollFunction
getwindowvscrollfunction (WindowVScroll f) = f

getwindoworigin :: !(WindowAttribute .ps) -> Point
getwindoworigin (WindowOrigin origin) = origin

getwindowminimumsize :: !(WindowAttribute .ps) -> Size
getwindowminimumsize (WindowMinimumSize size) = size

getwindowmouseinfo :: !(WindowAttribute .ps) -> (MouseStateFilter,SelectState,MouseFunction .ps)
getwindowmouseinfo (WindowMouse filter select mouseF) = (filter,select,mouseF)

getwindowkeyboardinfo :: !(WindowAttribute .ps) -> (KeyboardStateFilter,SelectState,KeyboardFunction .ps)
getwindowkeyboardinfo (WindowKeyboard filter select keysF) = (filter,select,keysF)

getwindowactivatefunction :: !(WindowAttribute .ps) -> IOFunction .ps
getwindowactivatefunction (WindowActivate f) = f

getwindowdeactivatefunction :: !(WindowAttribute .ps) -> IOFunction .ps
getwindowdeactivatefunction (WindowDeactivate f) = f

getwindowcursor :: !(WindowAttribute .ps) -> CursorShape
getwindowcursor (WindowCursor cShape) = cShape
